
import static com.xebialabs.restito.builder.stub.StubHttp.whenHttp;
import static com.xebialabs.restito.semantics.Condition.custom;
import static com.xebialabs.restito.semantics.Condition.method;
import static com.xebialabs.restito.semantics.Action.status;

import org.glassfish.grizzly.http.Method;
import org.glassfish.grizzly.http.server.Response;
import org.glassfish.grizzly.http.util.HttpStatus;


import com.xebialabs.restito.semantics.Call;
import com.xebialabs.restito.semantics.Function;
import com.xebialabs.restito.semantics.Predicate;
import com.xebialabs.restito.server.StubServer;

import java.io.IOException;

public class CancelAppointmentMock extends AbstractMock {
    private static String appointmentTemplate;

    public CancelAppointmentMock() {
        appointmentTemplate  = loadTemplate("canceled-appointment-template.txt");
    }

    @Override
    public void run(StubServer server) {
        Predicate<Call> validCancelAppointmentRequest = new Predicate<Call>() {
            @Override
            public boolean apply(final Call input) {
                return input.getUri().matches(".*/VeteranAppointmentRequestService/v4/rest/direct-scheduling/site/\\d+/patient/EDIPI/.*/cancel-appointment");
            }
        };

        Predicate<Call> requestToGenerateErrorMessage = new Predicate<Call>() {
            @Override
            public boolean apply(final Call input) {
                return input.getUri().matches(".*/VeteranAppointmentRequestService/v4/rest/direct-scheduling/site/\\d+/patient/EDIPI/1/cancel-appointment");
            }
        };

        Function<Response, Response> canceledAppointment = new Function<Response, Response>() {
            @Override
            public Response apply(Response input) {
                String uri = input.getRequest().getRequestURI();
                String patientIdRegex = ".*/EDIPI/(.*)/cancel-appointment";

                String patientId = matchingRegex(uri, patientIdRegex);
                String output = createCanceledAppointment(patientId);

                try {
                    input.getWriter().write(output);
                } catch (IOException e) {
                    e.printStackTrace();
                }

                return input;
            }
        };

        whenHttp(server).match(custom(validCancelAppointmentRequest), method(Method.PUT))
            .then(status(HttpStatus.OK_200));

        whenHttp(server).match(custom(requestToGenerateErrorMessage), method(Method.PUT))
        .then(generateResponse(HttpStatus.BAD_REQUEST_400, "Error: Unable to cancel appointment"));
    }

    private String createCanceledAppointment(String patientId) {
        return String.format(appointmentTemplate, patientId);
    }
}
